(function (Drupal) {
  'use strict';

  Drupal.behaviors.codePreviewResize = {
    attach: function (context, settings) {
      const iframes = context.querySelectorAll('iframe.code-preview');
      iframes.forEach(function (iframe) {
        // Пропускаем, если уже обработан.
        if (iframe.dataset.resized) {
          return;
        }

        iframe.onload = function () {
          try {
            const doc = this.contentDocument || this.contentWindow.document;
            const height = doc.documentElement.scrollHeight;
            this.style.height = height + 'px';
            this.dataset.resized = 'true';
          } catch (e) {
            // Игнорируем ошибки (например, пустой srcdoc).
          }
        };

        // Запускаем вручную, если iframe уже загружен.
        if (iframe.contentDocument && iframe.contentDocument.readyState === 'complete') {
          iframe.onload();
        }
      });
    }
  };

})(Drupal);
