<?php

namespace Drupal\code_preview\Plugin\Filter;

use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;
use Drupal\Component\Serialization\Json;
use Drupal\Component\Utility\Html as HtmlUtility;

/**
 * @Filter(
 *   id = "code_preview_filter",
 *   title = @Translation("Code Preview"),
 *   type = \Drupal\filter\Plugin\FilterInterface::TYPE_TRANSFORM_REVERSIBLE,
 * )
 */
class CodePreviewFilter extends FilterBase {

  public function process($text, $langcode) {
    if (!is_string($text)) {
      return new FilterProcessResult($text);
    }

    $dom = HtmlUtility::load($text);
    $xpath = new \DOMXPath($dom);

    $nodes = $xpath->query('//highlight-js[@data-plugin-config]');

    foreach ($nodes as $node) {
      $config_json = $node->getAttribute('data-plugin-config');
      $config = Json::decode($config_json);

      $raw_code = $config['text'] ?? '';
      if (empty($raw_code)) {
        continue;
      }

      // Декодируем \uXXXX через JSON-хак
      $decoded = json_decode('"' . $raw_code . '"', TRUE, 512, JSON_UNESCAPED_UNICODE);
      if ($decoded === NULL) {
        $decoded = preg_replace_callback('/\\\\u([0-9a-fA-F]{4})/', function ($match) {
          return mb_convert_encoding(pack('H*', $match[1]), 'UTF-8', 'UCS-2BE');
        }, $raw_code);
      }

      $show_preview = !empty($config['preview']) || !empty($config['preview_hide_code']);
      $hide_code = !empty($config['preview_hide_code']);

      $output = '';

      if (!$hide_code) {
        $output .= $dom->saveHTML($node);
      }

      if ($show_preview) {
        //$full_html = '<!DOCTYPE html><html><head><meta charset="utf-8"><style>body{margin:0;padding:8px;}</style></head><body>' . $decoded . '</body></html>';
        $full_html = '<!DOCTYPE html><html><head><meta charset="utf-8"><style>body{margin:0;padding:8px;overflow:hidden;}</style></head><body>' . $decoded . '</body></html>';
        $srcdoc = htmlspecialchars($full_html, ENT_QUOTES, 'UTF-8');
        //$output .= '<iframe srcdoc="' . $srcdoc . '" class="code-preview" frameborder="0" style="width:100%;min-height:100px;"></iframe>';
        //$output .= '<iframe srcdoc="' . $srcdoc . '" class="code-preview" frameborder="0" style="width:100%; height:0; border:none; overflow:hidden;"></iframe>';

        $output .= '<iframe srcdoc="' . $srcdoc . '" class="code-preview" frameborder="0"></iframe>';
      }

      $new_node = $dom->createDocumentFragment();
      $new_node->appendXML($output);
      $node->parentNode->replaceChild($new_node, $node);
    }

    return new FilterProcessResult(HtmlUtility::serialize($dom));
  }
}
